"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const user_entity_1 = require("./entities/user.entity");
const typeorm_2 = require("typeorm");
const bcrypt = require("bcrypt");
const order_entity_1 = require("../orders/entities/order.entity");
const enums_1 = require("../Enums/enums");
let UsersService = class UsersService {
    userRepository;
    orderRepository;
    constructor(userRepository, orderRepository) {
        this.userRepository = userRepository;
        this.orderRepository = orderRepository;
    }
    async create(createUserDto) {
        const userExist = await this.userRepository.findOne({
            where: [
                { email: createUserDto.email },
                { document: createUserDto.document }
            ],
        });
        if (userExist) {
            throw new common_1.ConflictException({ message: 'Ops. E-mail ou documento já cadastrados' });
        }
        try {
            const password = await bcrypt.hash(createUserDto.password, 10);
            const user = this.userRepository.create({
                ...createUserDto,
                password
            });
            this.userRepository.save(user);
        }
        catch (error) {
            throw new common_1.BadRequestException({ message: 'Ops! Algo deu errado durante a criação do usuário' });
        }
        return "Usuário criado com sucesso";
    }
    findAll() {
        return this.userRepository.find();
    }
    async findOne(id) {
        const user = await this.userRepository.findOne({
            where: {
                id,
            },
        });
        if (!user) {
            throw new common_1.NotFoundException("Ops. Não foi possível encontrar um usuário com o id " + id);
        }
        const summary = await this.orderRepository
            .createQueryBuilder('order')
            .select('COUNT(order.id)', 'totalOrders')
            .addSelect('SUM(order.total_items)', 'totalProducts')
            .where('order.status != :status AND order.userId = :id', { status: enums_1.Status.OPEN, id })
            .getRawOne();
        return {
            id: user.id,
            document: user.document,
            name: user.user_name,
            email: user.email,
            cellphone: user.cellphone,
            totalOrders: Number(summary.totalOrders) || 0,
            totalProducts: Number(summary.totalProducts) || 0,
        };
    }
    findOneByEmail(email) {
        return this.userRepository.findOneBy({ email });
    }
    update(id, updateUserDto) {
        return `This action updates a #${id} user`;
    }
    async remove(id) {
        const user = await this.userRepository.findOneBy({ id });
        if (!user) {
            throw new common_1.NotFoundException("Ops. Usuário não encontrado");
        }
        try {
            this.userRepository.remove(user);
        }
        catch (error) {
            throw new common_1.BadRequestException("Ops. Erro ao tentar excluir usuário");
        }
        return "Usuário excluído com sucesso";
    }
};
exports.UsersService = UsersService;
exports.UsersService = UsersService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __param(1, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], UsersService);
//# sourceMappingURL=users.service.js.map