"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StoreProductsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const store_product_entity_1 = require("./entities/store_product.entity");
const typeorm_2 = require("typeorm");
const product_entity_1 = require("../products/entities/product.entity");
const store_entity_1 = require("../store/entities/store.entity");
let StoreProductsService = class StoreProductsService {
    storeProductRepository;
    productRepository;
    storeRepository;
    constructor(storeProductRepository, productRepository, storeRepository) {
        this.storeProductRepository = storeProductRepository;
        this.productRepository = productRepository;
        this.storeRepository = storeRepository;
    }
    create(createStoreProductDto) {
    }
    async findHighlightedProductsByStore(id) {
        const store = await this.storeRepository.findOneBy({ id });
        if (!store) {
            throw new common_1.NotFoundException("Ops. Unidade não encontrada");
        }
        return this.storeProductRepository
            .createQueryBuilder('store_product')
            .leftJoinAndSelect('store_product.product', 'product')
            .where('store_product.highlighted = :highlighted', { highlighted: true })
            .andWhere('store_product.storeId = :storeId', { storeId: store.id })
            .select([
            'store_product.id AS id',
            'store_product.price AS price',
            'store_product.promotional_price AS promotional_price',
            'product.image AS image',
            'product.name AS name',
            'product.description AS description'
        ])
            .getRawMany();
    }
    async findAllByStore(id) {
        const storeProduct = await this.storeProductRepository
            .createQueryBuilder('storeProducts')
            .innerJoin('storeProducts.product', 'product')
            .innerJoin('storeProducts.store', 'store')
            .select([
            'store.store_name AS storeName',
            'storeProducts.id AS id',
            'storeProducts.custom_code as custom_codee',
            'storeProducts.visible as visible',
            'storeProducts.price as price',
            'product.name as name',
            'product.description as description',
            'product.image AS image',
            'product.line AS line',
            'product.category AS category',
        ])
            .where('storeProducts.storeId = :id', { id })
            .getRawMany();
        if (!storeProduct) {
            throw new common_1.NotFoundException("Ops. Unidade não encontrada");
        }
        return storeProduct;
    }
    findOne(id) {
        return `This action returns a #${id} storeProduct`;
    }
    async updateHighLightProduct(id, updateHighLightDto) {
        const product = await this.storeProductRepository.findOneBy({ id });
        if (!product) {
            throw new common_1.NotFoundException("Ops. Não fui encontrado com nenhum produto com o id " + id);
        }
        const promotional_price = (updateHighLightDto.promotional_price <= 0) ? product.price : updateHighLightDto.promotional_price;
        await this.storeProductRepository.update(id, { highlighted: !product.highlighted,
            promotional_price
        });
        return this.storeProductRepository.findOneBy({ id });
    }
    async updateVisibilityProduct(id) {
        const product = await this.storeProductRepository.findOneBy({ id });
        if (!product) {
            throw new common_1.NotFoundException("Ops. Não foi possível localizar um produto com o id " + id);
        }
        try {
            await this.storeProductRepository.update(id, {
                visible: !product.visible
            });
        }
        catch (error) {
            console.log("Erro durante a mudança de visibilidade: " + error);
            throw new common_1.BadRequestException("Ops. Algo de errado aconteceu durante a mudança de visibilidade do produto");
        }
        return "Visibilidade do produto alterada com sucesso";
    }
};
exports.StoreProductsService = StoreProductsService;
exports.StoreProductsService = StoreProductsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(store_product_entity_1.StoreProduct)),
    __param(1, (0, typeorm_1.InjectRepository)(product_entity_1.Product)),
    __param(2, (0, typeorm_1.InjectRepository)(store_entity_1.Store)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], StoreProductsService);
//# sourceMappingURL=store_products.service.js.map