import { CreateStoreProductDto } from './dto/create-store_product.dto';
import { UpdateHightLightDto } from './dto/update-store_product.dto';
import { StoreProduct } from './entities/store_product.entity';
import { Repository } from 'typeorm';
import { Product } from 'src/products/entities/product.entity';
import { Store } from 'src/store/entities/store.entity';
export declare class StoreProductsService {
    private storeProductRepository;
    private productRepository;
    private storeRepository;
    constructor(storeProductRepository: Repository<StoreProduct>, productRepository: Repository<Product>, storeRepository: Repository<Store>);
    create(createStoreProductDto: CreateStoreProductDto): void;
    findHighlightedProductsByStore(id: number): Promise<any[]>;
    findAllByStore(id: number): Promise<any[]>;
    findOne(id: number): string;
    updateHighLightProduct(id: number, updateHighLightDto: UpdateHightLightDto): Promise<StoreProduct | null>;
    updateVisibilityProduct(id: number): Promise<string>;
}
