"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StoresService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const store_entity_1 = require("./entities/store.entity");
const typeorm_2 = require("typeorm");
const product_entity_1 = require("../products/entities/product.entity");
const store_product_entity_1 = require("../store_products/entities/store_product.entity");
const user_entity_1 = require("../users/entities/user.entity");
const administrators_store_entity_1 = require("../administrators_stores/entities/administrators_store.entity");
const address_service_1 = require("../address/address.service");
const order_entity_1 = require("../orders/entities/order.entity");
const store_gateway_1 = require("./store.gateway");
const bcrypt = require("bcrypt");
const enums_1 = require("../Enums/enums");
let StoresService = class StoresService {
    storeRepository;
    productsRepository;
    storeProductRepository;
    userRepository;
    administratorsStore;
    orderRepository;
    addressService;
    storeGateway;
    constructor(storeRepository, productsRepository, storeProductRepository, userRepository, administratorsStore, orderRepository, addressService, storeGateway) {
        this.storeRepository = storeRepository;
        this.productsRepository = productsRepository;
        this.storeProductRepository = storeProductRepository;
        this.userRepository = userRepository;
        this.administratorsStore = administratorsStore;
        this.orderRepository = orderRepository;
        this.addressService = addressService;
        this.storeGateway = storeGateway;
    }
    async create(createStoreDto) {
        const storeExist = await this.storeRepository.findOne({
            where: {
                document: createStoreDto.document
            }
        });
        if (storeExist) {
            throw new common_1.ConflictException("Ops. Já existe uma unidade cadastrada com esse CNPJ");
        }
        const password = await bcrypt.hash(createStoreDto.password, 10);
        const store = this.storeRepository.create({
            ...createStoreDto,
            store_name: createStoreDto.storeName,
            password
        });
        const addressExist = this.addressService.findCepAPI(createStoreDto.zipCode, 2);
        if ((await addressExist).status !== 200) {
            throw new common_1.NotFoundException("Ops. CEP não encontrado");
        }
        try {
            const savedStore = await this.storeRepository.save(store);
            console.log({ cep: createStoreDto.zipCode, store: savedStore.id, number: createStoreDto.number, complement: createStoreDto.storeName, type: "Loja Croissant & CIA", reference: createStoreDto.storeName, name_address: createStoreDto.storeName });
            this.addressService.create({ zipCode: createStoreDto.zipCode, store: savedStore.id, number: createStoreDto.number, complement: createStoreDto.storeName, type: "Loja Croissant & CIA", reference: createStoreDto.storeName, name_address: createStoreDto.storeName });
            const products = await this.productsRepository.find();
            const storeProducts = products.map(product => this.storeProductRepository.create({
                product,
                store: savedStore,
                custom_code: product.cod_factory,
                visible: true,
                price: 0
            }));
            const storeCreated = await this.storeProductRepository.save(storeProducts);
        }
        catch (error) {
            throw new common_1.BadRequestException("Ops. Não foi possível cadastrar uma nova unidade");
        }
        return "Unidade criada com sucesso";
    }
    findAll() {
        return this.storeRepository.find();
    }
    async findOrdersByStore(id, status) {
        const store = await this.storeRepository.findOneBy({ id });
        if (!store) {
            throw new common_1.NotFoundException("Ops. Unidade não encontrada");
        }
        let orders;
        if (!status) {
            orders = await this.orderRepository
                .createQueryBuilder('order')
                .innerJoin('order.user', 'user')
                .innerJoin('order.order_transaction', 'orderTransaction')
                .select([
                'order.id AS id',
                'order.status AS status',
                'order.total_items AS total_items',
                'order.sub_total AS total',
                'user.user_name AS name',
                'orderTransaction.updated_at AS updated_at',
            ])
                .where('order.storeId = :id and order.status != "open"', { id })
                .getRawMany();
        }
        else {
            orders = await this.orderRepository
                .createQueryBuilder('order')
                .innerJoin('order.user', 'user')
                .innerJoin('order.order_transaction', 'orderTransaction')
                .select([
                'order.id AS id',
                'order.status AS status',
                'order.total_items AS total_items',
                'order.sub_total AS total',
                'orderTransaction.updated_at AS updated_at',
            ])
                .where('order.storeId = :id and order.status != :status', { id, status: enums_1.Status.OPEN })
                .getRawMany();
        }
        return orders;
    }
    async findAllByAdministrator(id) {
        const user = await this.userRepository.findOneBy({ id });
        console.log(user);
        if (!user || user.role !== 'admin') {
            throw new common_1.NotFoundException("Administrador não encontrado");
        }
        const stores = this.administratorsStore
            .createQueryBuilder('administrator_store')
            .innerJoin('administrator_store.administrator', 'administrator')
            .innerJoin('administrator_store.store', 'store')
            .select([
            'administrator_store.id',
            'store.id',
            'store.document',
            'store.cep',
        ])
            .where('administrator.userId == :id', { id })
            .getRawMany();
        return stores;
    }
    findOne(id) {
        return this.storeRepository.findOneBy({ id });
    }
    async changeOrderStatusById(id, status) {
        const order = await this.orderRepository.findOne({
            where: { id },
            relations: ['user'],
        });
        if (!order || !order.user) {
            throw new common_1.NotFoundException("Ops. Pedido não encontrado");
        }
        const user = await this.userRepository.findOneBy({ id: order.user.id });
        if (!user) {
            throw new common_1.NotFoundException("Ops. Cliente não encontrado");
        }
        try {
            switch (status) {
                case enums_1.Status.OPEN:
                case enums_1.Status.PAID:
                case enums_1.Status.ON_THE_WAY:
                case enums_1.Status.CANCELED:
                case enums_1.Status.DELIVERED:
                    order.status = status;
                    await this.orderRepository.save(order);
                    this.storeGateway.notifyUserOrderStatusChange("cus_000006902232", order.id, status);
                    break;
                default:
                    console.log('Unknown order status.');
            }
        }
        catch (error) {
            throw new Error(error);
        }
    }
    update(id, updateStoreDto) {
        return `This action updates a #${id} store`;
    }
    remove(id) {
        return `This action removes a #${id} store`;
    }
};
exports.StoresService = StoresService;
exports.StoresService = StoresService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(store_entity_1.Store)),
    __param(1, (0, typeorm_1.InjectRepository)(product_entity_1.Product)),
    __param(2, (0, typeorm_1.InjectRepository)(store_product_entity_1.StoreProduct)),
    __param(3, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __param(4, (0, typeorm_1.InjectRepository)(administrators_store_entity_1.AdministratorsStore)),
    __param(5, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        address_service_1.AddressService,
        store_gateway_1.StoreGateway])
], StoresService);
//# sourceMappingURL=stores.service.js.map