"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrdersService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const user_entity_1 = require("../users/entities/user.entity");
const typeorm_2 = require("typeorm");
const store_entity_1 = require("../store/entities/store.entity");
const order_entity_1 = require("./entities/order.entity");
const order_item_entity_1 = require("../order_items/entities/order_item.entity");
const store_product_entity_1 = require("../store_products/entities/store_product.entity");
const asaas_service_1 = require("../asaas/asaas.service");
const order_transactions_service_1 = require("../order_transactions/order_transactions.service");
const enums_1 = require("../Enums/enums");
let OrdersService = class OrdersService {
    orderRepository;
    userRepository;
    storeRepository;
    orderItemRepository;
    storeProductRepository;
    asaasService;
    orderTransactionService;
    dataSource;
    constructor(orderRepository, userRepository, storeRepository, orderItemRepository, storeProductRepository, asaasService, orderTransactionService, dataSource) {
        this.orderRepository = orderRepository;
        this.userRepository = userRepository;
        this.storeRepository = storeRepository;
        this.orderItemRepository = orderItemRepository;
        this.storeProductRepository = storeProductRepository;
        this.asaasService = asaasService;
        this.orderTransactionService = orderTransactionService;
        this.dataSource = dataSource;
    }
    async getOrCreateOpenOrder(userId, storeId) {
        const user = await this.userRepository.findOneBy({ id: userId });
        if (!user) {
            throw new common_1.NotFoundException("Ops. Usuário não encontrado");
        }
        let order = await this.findOpenOrderByUser(userId);
        if (!order) {
            order = await this.orderRepository.save(this.orderRepository.create({ user: { id: userId }, store: { id: storeId } }));
            this.orderTransactionService.create(order, enums_1.Status.OPEN);
        }
        return order;
    }
    async findOpenOrderByUser(userId) {
        return await this.orderRepository.findOne({
            where: {
                user: { id: userId },
                status: enums_1.Status.OPEN,
            },
            relations: ['order_item', 'order_item.store_product', 'order_item.store_product.product'],
        });
    }
    async getTopProductsPerDay(storeId) {
        const query = this.orderRepository
            .createQueryBuilder('order')
            .innerJoinAndSelect('order.order_item', 'orderItem')
            .innerJoinAndSelect('orderItem.store_product', 'storeProducts')
            .innerJoinAndSelect('storeProducts.product', 'products')
            .innerJoinAndSelect('order.order_transaction', 'orderTransaction')
            .select([
            'DISTINCT storeProducts.id AS id',
            'SUM(orderItem.quantity ) AS total',
            'products.name AS name',
            'products.image AS image',
            'products.description AS description',
            'storeProducts.price AS price',
            'storeProducts.highlighted AS highlighted',
        ])
            .where('order.storeId = :storeId', { storeId })
            .andWhere('order.status != :status', { status: enums_1.Status.OPEN })
            .andWhere('order.status != :status', { status: enums_1.Status.CANCELED })
            .groupBy('storeProducts.id')
            .addGroupBy('products.name')
            .addGroupBy('products.image')
            .addGroupBy('products.description')
            .addGroupBy('storeProducts.price')
            .addGroupBy('storeProducts.highlighted')
            .orderBy('total', 'DESC')
            .limit()
            .getRawMany();
        return query;
    }
    async checkout(id) {
        const user = await this.userRepository.findOneBy({ id });
        if (!user) {
            throw new common_1.NotFoundException("Ops. Usuário não encontrado");
        }
        const hasOpenOrder = await this.orderRepository.findOne({
            where: {
                user: { id },
                status: enums_1.Status.OPEN,
            },
        });
        console.log("Console1");
        if (!hasOpenOrder) {
            throw new common_1.NotFoundException("Ops. Nâo foi encontrado pedidos em aberto para esse usuário");
        }
        const hasOrderItems = await this.orderItemRepository
            .createQueryBuilder('orderItems')
            .innerJoin('orderItems.order', 'order')
            .innerJoin('orderItems.store_product', 'storeProduct')
            .select([
            'orderItems.id AS id',
            'order.storeId AS orderStoreId',
            'storeProduct.storeId AS productStoreId'
        ])
            .where('orderId = :id', { id: hasOpenOrder.id })
            .getRawMany();
        console.log("Console2");
        if (!hasOrderItems) {
            throw new common_1.NotFoundException("Ops. Não foi encontrado itens no carrinho desse usuário");
        }
        for (const item of hasOrderItems) {
            let contador = 0;
            console.log((item.productStoreId));
            if (item.orderStoreId !== item.productStoreId) {
                try {
                    await this.orderItemRepository.delete(item.id);
                    hasOrderItems.splice(contador, 1);
                }
                catch (error) {
                    throw new common_1.NotFoundException(`Ops. Não foi possível remover o item ${item.id} do pedido`);
                }
            }
            ;
            if (hasOrderItems.length === 0) {
                throw new common_1.BadRequestException('Ops. Não há itens o suficiente no carrinho para proseguir com a compra');
            }
            contador++;
        }
        let updatedValues;
        try {
            updatedValues = (await this.updateQuantityAndSubTotalOrder(hasOpenOrder.id))?.sub_total;
            console.log("update" + updatedValues);
            if (!updatedValues) {
                throw new common_1.BadRequestException("Erro ao tentar retornar os valores do pedido");
            }
        }
        catch (error) {
            throw new common_1.BadRequestException(error);
        }
        return await this.asaasService.createLeanPayment({ name: user.user_name, email: user.email, mobilePhone: user.cellphone, cpfCnpj: user.document, value: updatedValues });
    }
    async getDetailsByOrder(id) {
        const order = this.orderRepository.findOneBy({ id });
        if (!order) {
            throw new common_1.NotFoundException("Ops. Pedido não encontrado");
        }
        const orderDetails = this.orderItemRepository
            .createQueryBuilder('order-item')
            .innerJoinAndSelect('order-item.order', 'order')
            .innerJoinAndSelect('order-item.store_product', 'store_product')
            .innerJoinAndSelect('store_product.product', 'product')
            .select([
            'order.id',
            'order.total_items',
            'order.sub_total',
            'order.created_at',
            'store_product.id',
            'product.name',
            'product.description',
            'product.image',
            'custom_code',
            'quantity',
            'store_product.price AS unit_price'
        ])
            .where('orderId = :id ', { id })
            .getRawMany();
        return orderDetails;
    }
    async findPaidOrdersByUser(id) {
        const user = await this.userRepository.findOneBy({ id });
        if (!user) {
            throw new common_1.NotFoundException('Ops. Usuário não encontrado');
        }
        const orders = await this.orderRepository
            .createQueryBuilder('order')
            .innerJoin('order.user', 'user')
            .select([
            'order.id AS id',
            'order.status AS status',
            'order.sub_total AS total',
            'order.total_items AS totalItems',
        ])
            .where('order.status != :status AND user.id = :id', { status: enums_1.Status.OPEN, id })
            .getRawMany();
        const summary = await this.orderRepository
            .createQueryBuilder('order')
            .select('COUNT(order.id)', 'totalOrders')
            .addSelect('SUM(order.total_items)', 'totalProducts')
            .where('order.status != :status AND order.userId = :id', { status: enums_1.Status.OPEN, id })
            .getRawOne();
        return orders;
    }
    async getOrderPerHour(storeId, date) {
        const store = await this.storeRepository.findOneBy({ id: storeId });
        console.log("Primeiro");
        if (!store) {
            throw new common_1.NotFoundException("Ops. Unidade não encontrada");
        }
        if (!date) {
            date = new Date().toISOString().slice(0, 10);
        }
        console.log("Segundo");
        if (!/^\d{4}-\d{2}-\d{2}$/.test(date)) {
            throw new common_1.BadRequestException('Data inválida. Use o formato YYYY-MM-DD');
        }
        console.log("Terceiro");
        const fullHours = Array.from({ length: 24 }, (_, i) => ({
            hour: `${i.toString().padStart(2, '0')}:00`,
            total: 0,
        }));
        console.log("Quarto");
        const results = await this.orderRepository
            .createQueryBuilder('order')
            .innerJoin('order.order_transaction', 'orderTransaction')
            .select(`DATE_FORMAT(orderTransaction.updated_at, '%H:00')`, 'hour')
            .addSelect('COUNT(*)', 'total')
            .where('DATE(orderTransaction.updated_at) = :date', { date })
            .andWhere('order.storeId = :storeId', { storeId: store.id })
            .andWhere('order.status != :status', { status: enums_1.Status.OPEN })
            .groupBy('hour')
            .orderBy('hour', 'ASC')
            .getRawMany();
        console.log("Quinto");
        console.log(results);
        const merged = fullHours.map(h => {
            const found = results.find(r => r.hour === h.hour);
            return {
                hour: h.hour,
                total: found ? Number(found.total) : 0,
            };
        });
        return merged;
    }
    async findShopCartByUser(id) {
        const order = await this.orderRepository
            .createQueryBuilder('order')
            .innerJoin('order.user', 'user')
            .innerJoin('order.order_item', 'order_item')
            .innerJoin('order_item.store_product', 'store_product')
            .innerJoin('store_product.product', 'product')
            .innerJoin('store_product.store', 'store')
            .select([
            'order.storeId AS orderStoreId',
            'store_product.id AS id ',
            'store_product.storeId AS productStoreId',
            'store.store_name AS storeName',
            'product.name AS name',
            'product.image AS image',
            'product.description AS description',
            'order_item.quantity AS quantity',
            'store_product.price AS price',
        ])
            .where('user.id = :id and order.status = :status ', { id, status: enums_1.Status.OPEN })
            .getRawMany();
        order.forEach(item => {
            if (item.orderStoreId !== item.productStoreId) {
                item.alert = `Item disponível somente na loja ${item.storeName}`;
                delete item.orderStoreId;
                delete item.productStoreId;
            }
        });
        return order;
    }
    async changeOrderStatusById(id, status) {
        const order = await this.orderRepository.findOneBy({ id });
        if (!order) {
            throw new common_1.NotFoundException("Ops. Pedido não encontrado");
        }
        const orderStatusUpdated = order.status = status;
        await this.orderRepository.update(order.id, { status: orderStatusUpdated });
        this.orderTransactionService.create(order, status);
        return await this.orderRepository.findOneBy({ id });
    }
    async updateQuantityAndSubTotalOrder(orderId) {
        const order = await this.orderRepository.findOneBy({ id: orderId });
        if (!order) {
            throw new common_1.NotFoundException("Ops. O registro do pedido não existe");
        }
        const orderItem = await this.orderRepository
            .createQueryBuilder('order')
            .innerJoin('order.order_item', 'orderItem')
            .innerJoin('orderItem.store_product', 'storeProduct')
            .select('SUM(orderItem.quantity * storeProduct.price)', 'sub_total')
            .addSelect('SUM(orderItem.quantity)', 'total_items')
            .where('order.id = :id', { id: orderId })
            .getRawOne();
        try {
            await this.orderRepository.update(orderId, { sub_total: orderItem.sub_total, total_items: orderItem.total_items });
            return await this.orderRepository.findOne({
                where: {
                    id: orderId,
                },
                select: ['sub_total'],
            });
        }
        catch (error) {
            throw new common_1.BadRequestException("Ops. Erro ao tentar atualziar os valores de preço e quantidade no pedido");
        }
    }
};
exports.OrdersService = OrdersService;
exports.OrdersService = OrdersService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __param(1, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __param(2, (0, typeorm_1.InjectRepository)(store_entity_1.Store)),
    __param(3, (0, typeorm_1.InjectRepository)(order_item_entity_1.OrderItem)),
    __param(4, (0, typeorm_1.InjectRepository)(store_product_entity_1.StoreProduct)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        asaas_service_1.AsaasService,
        order_transactions_service_1.OrderTransactionsService,
        typeorm_2.DataSource])
], OrdersService);
//# sourceMappingURL=orders.service.js.map