import { CreateOrderItemDto } from './dto/create-order_item.dto';
import { UpdateOrderItemDto } from './dto/update-order_item.dto';
import { OrdersService } from 'src/orders/orders.service';
import { OrderItem } from './entities/order_item.entity';
import { Repository } from 'typeorm';
import { StoreProduct } from 'src/store_products/entities/store_product.entity';
import { User } from 'src/users/entities/user.entity';
import { Order } from 'src/orders/entities/order.entity';
export declare class OrderItemsService {
    private orderRepository;
    private orderItemRepository;
    private storeProduct;
    private userRepository;
    private readonly ordersService;
    constructor(orderRepository: Repository<Order>, orderItemRepository: Repository<OrderItem>, storeProduct: Repository<StoreProduct>, userRepository: Repository<User>, ordersService: OrdersService);
    create(createOrderItemDto: CreateOrderItemDto): Promise<string>;
    countByUser(id: number): Promise<any>;
    updateItemQuantity(id: number, updateOrderItemDto: UpdateOrderItemDto): Promise<OrderItem>;
    remove(id: number, prodId: number): Promise<string>;
}
