"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DriverService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const driver_entity_1 = require("./entities/driver.entity");
const bcrypt = require("bcrypt");
const store_entity_1 = require("../store/entities/store.entity");
let DriverService = class DriverService {
    driverRepository;
    storeRepository;
    constructor(driverRepository, storeRepository) {
        this.driverRepository = driverRepository;
        this.storeRepository = storeRepository;
    }
    async create(createDriverDto) {
        const store = await this.storeRepository.findOneBy({ id: createDriverDto.storeId });
        if (!store) {
            throw new common_1.NotFoundException("Ops. Não foi possível localizar a loja informada");
        }
        const driver = await this.driverRepository.findOne({
            where: [
                { document: createDriverDto.document },
                { email: createDriverDto.document }
            ]
        });
        if (driver) {
            throw new common_1.ConflictException("Documento ou e-mail já está sendo utilizado");
        }
        try {
            const password = await bcrypt.hash(createDriverDto.password, 10);
            await this.driverRepository.save(this.driverRepository.create({
                ...createDriverDto,
                stores: [store],
                password
            }));
        }
        catch (error) {
            console.log(error);
            throw new common_1.BadRequestException("Ops. Houve um erro ao tentar criar um parceiro");
        }
        return "Parceiro criado com sucesso";
    }
    async findAllByStore(id) {
        return this.driverRepository
            .createQueryBuilder('driver')
            .innerJoinAndSelect('driver.stores', 'store')
            .select([
            'driver.id  AS id',
            'driver.driver_name AS driver_name',
            'driver.document AS document',
            'driver.cnh AS cnh',
            'driver.email AS email',
            'driver.cellphone AS cellphone'
        ])
            .where('store.id = :id', { id })
            .getRawMany();
    }
    findOne(id) {
        return this.driverRepository.findOneBy({ id });
    }
    async update(id, updateDriverDto) {
        const driver = await this.driverRepository.findOne({
            where: { id },
            relations: ['stores'],
        });
        if (!driver) {
            throw new common_1.NotFoundException(`Driver with ID ${id} not found`);
        }
        if (updateDriverDto.store_id && updateDriverDto.store_id.length > 0) {
            const stores = await this.storeRepository.findBy({ id: (0, typeorm_2.In)(updateDriverDto.store_id) });
            driver.stores = stores;
        }
        Object.assign(driver, updateDriverDto);
        return this.driverRepository.save(driver);
    }
    async remove(id) {
        const driver = await this.driverRepository.findOneBy({ id });
        if (!driver) {
            throw new common_1.NotFoundException("Ops. Parceiro não encontrado");
        }
        try {
            this.driverRepository.remove(driver);
        }
        catch (error) {
            throw new common_1.BadRequestException("Ops. Erro ao tentar remover motorista");
        }
        return "Entregador removido com sucesso";
    }
};
exports.DriverService = DriverService;
exports.DriverService = DriverService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(driver_entity_1.Driver)),
    __param(1, (0, typeorm_1.InjectRepository)(store_entity_1.Store)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], DriverService);
//# sourceMappingURL=driver.service.js.map