import { CreateDriverDto } from './dto/create-driver.dto';
import { UpdateDriverDto } from './dto/update-driver.dto';
import { Repository } from 'typeorm';
import { Driver } from './entities/driver.entity';
import { Store } from 'src/store/entities/store.entity';
export declare class DriverService {
    private driverRepository;
    private storeRepository;
    constructor(driverRepository: Repository<Driver>, storeRepository: Repository<Store>);
    create(createDriverDto: CreateDriverDto): Promise<string>;
    findAllByStore(id: number): Promise<any[]>;
    findOne(id: number): Promise<Driver | null>;
    update(id: number, updateDriverDto: UpdateDriverDto): Promise<Driver>;
    remove(id: number): Promise<string>;
}
