"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthModule = void 0;
const common_1 = require("@nestjs/common");
const auth_service_1 = require("./auth.service");
const auth_controller_1 = require("./auth.controller");
const jwt_1 = require("@nestjs/jwt");
const users_module_1 = require("../users/users.module");
const auth_guard_1 = require("./auth.guard");
const address_module_1 = require("../address/address.module");
const typeorm_1 = require("@nestjs/typeorm");
const store_entity_1 = require("../store/entities/store.entity");
let AuthModule = class AuthModule {
};
exports.AuthModule = AuthModule;
exports.AuthModule = AuthModule = __decorate([
    (0, common_1.Module)({
        imports: [
            users_module_1.UsersModule, address_module_1.AddressModule, typeorm_1.TypeOrmModule.forFeature([store_entity_1.Store]),
            jwt_1.JwtModule.register({
                secret: process.env.JWT_SECRET || 'secret',
            }),
        ],
        providers: [auth_service_1.AuthService, auth_guard_1.AuthGuard],
        controllers: [auth_controller_1.AuthController],
        exports: [auth_guard_1.AuthGuard]
    })
], AuthModule);
//# sourceMappingURL=auth.module.js.map