"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const app_controller_1 = require("./app.controller");
const app_service_1 = require("./app.service");
const users_module_1 = require("./users/users.module");
const typeorm_1 = require("@nestjs/typeorm");
const ormconfig_1 = require("./ormconfig");
const products_module_1 = require("./products/products.module");
const administrators_module_1 = require("./administrators/administrators.module");
const clients_module_1 = require("./clients/clients.module");
const store_products_module_1 = require("./store_products/store_products.module");
const stores_module_1 = require("./store/stores.module");
const administrators_stores_module_1 = require("./administrators_stores/administrators_stores.module");
const delivery_records_module_1 = require("./delivery_records/delivery_records.module");
const delivery_order_module_1 = require("./delivery_order/delivery_order.module");
const orders_module_1 = require("./orders/orders.module");
const order_items_module_1 = require("./order_items/order_items.module");
const auth_module_1 = require("./auth/auth.module");
const config_1 = require("@nestjs/config");
const driver_module_1 = require("./driver/driver.module");
const address_module_1 = require("./address/address.module");
const asaas_module_1 = require("./asaas/asaas.module");
const axios_1 = require("@nestjs/axios");
const stock_transactions_module_1 = require("./stock_transactions/stock_transactions.module");
const stock_service_1 = require("./stock/stock.service");
const stock_module_1 = require("./stock/stock.module");
const order_transactions_module_1 = require("./order_transactions/order_transactions.module");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [axios_1.HttpModule,
            config_1.ConfigModule.forRoot({ isGlobal: true }),
            typeorm_1.TypeOrmModule.forRoot(ormconfig_1.config), users_module_1.UsersModule, products_module_1.ProductsModule, administrators_module_1.AdministratorsModule, clients_module_1.ClientsModule, store_products_module_1.StoreProductsModule, stores_module_1.StoresModule, administrators_stores_module_1.AdministratorsStoresModule, delivery_records_module_1.DeliveryRecordsModule, delivery_order_module_1.DeliveryOrderModule, orders_module_1.OrdersModule, order_items_module_1.OrderItemsModule, auth_module_1.AuthModule, driver_module_1.DriverModule, address_module_1.AddressModule, asaas_module_1.AsaasModule, stock_transactions_module_1.StockTransactionsModule, stock_module_1.StockModule, order_transactions_module_1.OrderTransactionsModule],
        controllers: [app_controller_1.AppController],
        providers: [app_service_1.AppService, stock_service_1.StockService],
    })
], AppModule);
//# sourceMappingURL=app.module.js.map