import { CreateAddressDto } from './dto/create-address.dto';
import { UpdateAddressDto } from './dto/update-address.dto';
import { Address } from './entities/address.entity';
import { Repository } from 'typeorm';
import { HttpService } from '@nestjs/axios';
import { User } from 'src/users/entities/user.entity';
import { Order } from 'src/orders/entities/order.entity';
type Entrada = {
    origem: "interno";
    id: number;
} | {
    origem: "externo";
    id: number;
};
export declare class AddressService {
    private addressRepository;
    private userRepository;
    private orderRepository;
    private readonly httpService;
    constructor(addressRepository: Repository<Address>, userRepository: Repository<User>, orderRepository: Repository<Order>, httpService: HttpService);
    create(createAddressDto: CreateAddressDto): Promise<Address>;
    findAllByUser(id: number): Promise<Address[]>;
    findStoreNearByUser(id: Entrada): Promise<{
        store: {
            id: any;
            zipCode: any;
            addressName: any;
        };
        zipCode: string;
    }>;
    update(id: number, updateAddressDto: UpdateAddressDto): Promise<string>;
    remove(id: number, enderecoId: number): Promise<string>;
    calculateDistance(userZipCode: string, storeZipCodes: any): Promise<{
        store: {
            id: any;
            zipCode: any;
            addressName: any;
        };
        zipCode: string;
    }>;
    findCepAPI(zipCode: string, option: number): Promise<import("axios").AxiosResponse<any, any>>;
}
export {};
